/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.hwyla;

import mcp.mobius.waila.api.IServerDataProvider;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.lookingat.LookingAtHelper;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.util.WorldUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public class HwylaDataProvider
implements IServerDataProvider<BlockEntity> {
    static final HwylaDataProvider INSTANCE = new HwylaDataProvider();

    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity tile, boolean showDetails) {
        if (tile instanceof TileEntityBoundingBlock) {
            TileEntityBoundingBlock boundingBlock = (TileEntityBoundingBlock)tile;
            if (!boundingBlock.hasReceivedCoords() || tile.m_58899_().equals((Object)boundingBlock.getMainPos())) {
                return;
            }
            tile = WorldUtils.getTileEntity((BlockGetter)world, boundingBlock.getMainPos());
            if (tile == null) {
                return;
            }
        }
        HwylaLookingAtHelper helper = new HwylaLookingAtHelper();
        LookingAtUtils.addInfo(helper, tile, true, true);
        helper.finalizeData(data);
    }

    static class HwylaLookingAtHelper
    implements LookingAtHelper {
        private final ListTag data = new ListTag();

        HwylaLookingAtHelper() {
        }

        @Override
        public void addText(Component text) {
            CompoundTag textData = new CompoundTag();
            textData.m_128359_("text", Component.Serializer.m_130703_((Component)text));
            this.data.add((Object)textData);
        }

        @Override
        public void addEnergyElement(FloatingLong energy, FloatingLong maxEnergy) {
            CompoundTag energyData = new CompoundTag();
            energyData.m_128359_("energy", energy.toString());
            energyData.m_128359_("max", maxEnergy.toString());
            this.data.add((Object)energyData);
        }

        @Override
        public void addFluidElement(FluidStack stored, int capacity) {
            CompoundTag fluidData = new CompoundTag();
            fluidData.m_128365_("fluid", (Tag)stored.writeToNBT(new CompoundTag()));
            fluidData.m_128405_("max", capacity);
            this.data.add((Object)fluidData);
        }

        @Override
        public void addChemicalElement(ChemicalStack<?> stored, long capacity) {
            CompoundTag chemicalData = new CompoundTag();
            chemicalData.m_128365_("chemical", (Tag)stored.write(new CompoundTag()));
            chemicalData.m_128356_("max", capacity);
            this.data.add((Object)chemicalData);
        }

        void finalizeData(CompoundTag data) {
            if (!this.data.isEmpty()) {
                data.m_128365_("mekData", (Tag)this.data);
            }
        }
    }
}

